
<?php
//add by morteza for sms
//گرفتن تنظیمات نوع ورود به سایت
$type = get_option('enable_mobile_in_forget_password', 0);

?>
<section class="sign-up-form">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1><?= lang("forgot_password") ?></h1>

                <p class="text-white"><?= lang("enter_your_registration_email_address_to_receive_password_reset_instructions") ?></p>
                <div class="form-container">
                    <form class="actionFormWithoutToast" action="<?= cn("auth/ajax_forgot_password") ?>" data-redirect="<?= cn('auth/login') ?>" method="POST" id="signUpForm" data-focus="false">
                        <?php if ($type == 0) { ?>
                            <div class="form-group">
                                <input type="email" class="form-control-input" name="email" required>
                                <label class="label-control" for="semail"><?php echo lang("Email"); ?></label>
                            </div>
                        <?php } else { ?>
                            <div class="form-group">
                                <div class="input-icon mb-5">
                                    <input type="text" class="form-control" name="mobile" id="mobile-number" dir="ltr" placeholder="موبایل"
                                           value="<?= (isset($cookie_mobile) && $cookie_mobile != "") ? $cookie_mobile : "" ?>"
                                           oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required>
                                </div>

                                <div class="input-icon mb-5 otp-password" style="display: none">
                                    <input type="password" class="form-control" name="password" id="password" placeholder="رمز عبور جدید"
                                           value="" required>
                                </div>


                                <div class="input-icon mb-5 otp-code" style="display: none">
                                    <input type="text" style="text-align: center" id="otp-code" dir="ltr" class="form-control" name="otp-code"
                                           oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" placeholder="کد تایید">

                                </div>

                                <label class="custom-control sub-otp-code" style="padding-right:0;display: none">
                            <span style="display: inline-block;" class="float-left">
                                <span id="forget-sms-timer">00 ثانیه</span>
                       </span>
                                    <a href="#" class="float-right small disabled" id="forget-send-active-code">ارسال مجدد کد تایید</a>
                                </label>

                            </div>
                        <?php } ?>
                        <div class="form-group mt-20">
                            <div id="alert-message" class="alert-message-reponse"></div>
                        </div>

                        <?php
                        if (get_option('enable_goolge_recapcha') && get_option('google_capcha_site_key') != "" && get_option('google_capcha_secret_key') != "") {
                            ?>
                            <div class="form-group">
                                <div class="g-recaptcha" data-sitekey="<?= get_option('google_capcha_site_key') ?>"></div>
                            </div>
                        <?php } ?>

                        <div class="form-group">
                            <button type="submit" class="form-control-submit-button btn-submit <?php if ($type == 1) { ?>send-otp-code<?php } ?>"><?= lang("Submit") ?></button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!--add for sms-->
<script>
    jQuery(document).ready(function ($) {

        $('body').on('click', '.send-otp-code', function (e) {
            e.preventDefault();
            send_otp_request();

        });

        $('body').on('click', '#forget-send-active-code', function (e) {
            e.preventDefault();
            onTimer("forget");
            send_otp_request();
        })


        /**
         * set 60 sec before resend active code
         */
        function onTimer(type) {
            //type is login or forget or remember
            //timer
            var count = <?= get_option('delay_sms', "60") ?>;
            $("#" + type + "-send-active-code").addClass('disabled');
            var timer = setInterval(function () {
                $("#" + type + "-sms-timer").html(count-- + " ثانیه");
                if (count == 0) {

                    $("#" + type + "-sms-timer").text("");
                    $("#" + type + "-send-active-code").removeClass('disabled');
                    $("#" + type + "-send-active-code").prop("disabled", false);
                    $("#" + type + "-status-active-code").text("");
                    $("#" + type + "-send-active-code").css("cursor", "pointer");

                    clearInterval(timer)
                }
            }, 1000);

        }

        function send_otp_request() {
            alertMessage.hide();
            var _that = $('.send-otp-code');
            let $mobile = $('#mobile-number').val();
            // let $email = $('#email').val();
            let $password = $('#password').val();
            let $code = $('#otp-code').val();
            $.ajax({
                type: 'post',
                url: "<?= cn("auth/ajax_forgot_password") ?>",
                data: 'mobile=' + $mobile + '&password=' + $password + '&code=' + $code + '&token=' + token + '&type=forget-password',
                beforeSend: function () {
                    _that.addClass('btn-loading');
                },
                success: function (result) {

                    result = JSON.parse(result);
                    if (result.type === "send_otp") {

                        //نشون دادن اطلاعیه
                        setTimeout(function () {
                            alertMessage.show(result.message, result.status);
                        }, 1500);

                        //اگر موفق بود فیلد وارد کردن کد رو نشون بده
                        if (result.status === "success") {
                            onTimer("forget");
                            $('.otp-code').show();
                            $('.otp-password').show();
                            $('.sub-otp-code').show();
                            $('.send-otp-code').text('بررسی کد تایید');
                            _that.removeClass('btn-loading');
                        }

                    } else {
                        //اگر موفق بود فیلد وارد کردن کد رو نشون بده
                        if (result.status === "success") {
                            //نشون دادن اطلاعیه
                            alertMessage.show(result.message, result.status);
                            setTimeout(function () {
                                window.location.replace("<?= cn('auth/login') ?>");
                            }, 3000);

                        } else {
                            //نشون دادن اطلاعیه
                            setTimeout(function () {
                                alertMessage.show(result.message, result.status);
                                _that.removeClass('btn-loading');
                            }, 2000);
                        }
                    }


                }
            });
        }
    });
</script>


