<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class profile extends My_UserController
{
    public $tb_users;
    public $controller_name;
    public $module_icon;

    public function __construct(){
        parent::__construct();
        $this->load->model(get_class($this).'_model', 'model');
        $this->controller_name = get_class($this);
        $this->tb_users = USERS;
    }

    public function index(){
        $data = array(
            "module"       => get_class($this),
            "user"         => $this->model->get('*', $this->tb_users, ['id' => session('uid')]),
        );
        $this->template->build('index', $data);
    }

    public function ajax_update($ids = ''){
        if (!$this->input->is_ajax_request()) redirect(cn($this->controller_name));
        $id                 = session('uid');
        $first_name         = post('first_name');
        $last_name          = post('last_name');
        
        $email              = post('email');
        $password           = post('password');
        $re_password        = post('re_password');
        $timezone           = post('timezone');
        $site_url           = post('site_url');
        if($first_name == '' || $last_name == ''){
            ms(array(
                'status'  => 'error',
                'message' => lang("please_fill_in_the_required_fields"),
            ));
        }
        $data = array(
            "first_name"              => $first_name,
            "last_name"               => $last_name,
            "timezone"                => $timezone,
            "site_url"                => $site_url,
            "changed"                 => NOW,
        );
        if($password != ''){
            if($password == ''){
                ms(array(
                    'status'  => 'error',
                    'message' => lang("Password_is_required"),
                ));
            }
            if(strlen($password) < 6){
                ms(array(
                    'status'  => 'error',
                    'message' => lang("Password_must_be_at_least_6_characters_long"),
                ));
            }
            if($re_password!= $password){
                ms(array(
                    'status'  => 'error',
                    'message' => lang("Password_does_not_match_the_confirm_password"),
                ));
            }
            $data['password'] = $this->model->app_password_hash($password);
        }
        if($id != ''){
            $checkUser = $this->model->get('id,ids,email', $this->tb_users, ['id' => $id]);
            if(empty($checkUser)){
                ms(array(
                    'status'  => 'error',
                    'message' => lang("There_was_an_error_processing_your_request_Please_try_again_later"),
                ));
            }
            if($email == ''){
                ms(array(
                    'status'  => 'error',
                    'message' => lang("email_is_required"),
                ));
            }
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                  ms(array(
                    'status'  => 'error',
                    'message' => lang("invalid_email_format"),
                ));
            }

            $checkUserEmail = $this->model->get('email, ids', $this->tb_users, ['email' => $email, 'id !=' => $id]);

            if(!empty($checkUserEmail)){
                ms(array(
                    'status'  => 'error',
                    'message' => lang("An_account_for_the_specified_email_address_already_exists_Try_another_email_address"),
                ));
            }

            $data['email']   = $email;

            if($this->db->update($this->tb_users, $data, ['id' => $id])){
                ms(array(
                    'status'  => 'success',
                    'message' => lang('Update_successfully'),
                ));
            }
        }else{
            ms(array(
                'status'  => 'error',
                'message' => lang("There_was_an_error_processing_your_request_Please_try_again_later"),
            ));
        }
    }

    public function ajax_update_more_infors($ids = ''){
        if (!$this->input->is_ajax_request()) redirect(cn($this->controller_name));
        $id                 = session('uid');
        $website            = post('website');
        $phone              = post('phone');
        $skype_id           = post('skype_id');
        $what_asap          = post('what_asap');
        $address            = post('address');

        $more_information = array(
            "website"         => $website,
            "phone"        	  => $phone,
            "what_asap"       => $what_asap,
            "skype_id"        => $skype_id,
            "address"         => $address,
        );

        $data = array(
            "more_information"        => json_encode($more_information),
            "changed"                 => NOW,
        );

        if($id != ''){
            $checkUser = $this->model->get('id,ids,email', $this->tb_users, ['id' => $id]);

            if(empty($checkUser)){
                ms(array(
                    'status'  => 'error',
                    'message' => lang("There_was_an_error_processing_your_request_Please_try_again_later"),
                ));
            }

            if($this->db->update($this->tb_users, $data, ['id' => $id])){
                ms(array(
                    'status'  => 'success',
                    'message' => lang('Updated_successfully'),
                ));
            }
        }else{
            ms(array(
                'status'  => 'error',
                'message' => lang("There_was_an_error_processing_your_request_Please_try_again_later"),
            ));
        }
    }

    public function ajax_update_api($ids = ''){
        if (!$this->input->is_ajax_request()) redirect(cn($this->controller_name));
        $id                 = session('uid');
        $api_key = create_random_string_key(32);
        $data = array(
            "api_key"         => $api_key,
            "changed"         => NOW,
        );
        if($id != ''){
            $checkUser = $this->model->get('id,ids,api_key', $this->tb_users,['id' => $id]);
            $checkApi_key = $this->model->get('id,ids,api_key', $this->tb_users, ['api_key' => $api_key]);
            if(empty($checkUser) || !empty($checkApi_key)){
                ms(array(
                    'status'  => 'error',
                    'message' => lang("There_was_an_error_processing_your_request_Please_try_again_later"),
                ));
            }
            if($this->db->update($this->tb_users, $data, ['id' => $id])){
                ms(array(
                    'status'  => 'success',
                    'message' => lang('Update_successfully'),
                ));
            }
        }else{
            ms(array(
                'status'  => 'error',
                'message' => lang("There_was_an_error_processing_your_request_Please_try_again_later"),
            ));
        }
    }

    //add by morteza for sms
    //برای ارسال کد تایید در تغییر شماره
    public function ajax_send_otp()
    {

        $code = post('code');
        $mobile = post('mobile');
        $number_digits_otp = empty(get_option('number_digits_otp', "4"))? 4 : get_option('number_digits_otp', "4");


        if (empty($mobile)) {
            ms(array(
                'status' => 'error',
                'message' => "لطفا شماره همراه را وارد نمایید",
            ));
        }

        if (!is_numeric($mobile)) {
            ms(array(
                'status' => 'error',
                'message' => "لطفا شماره همراه معتبری وارد نمایید",
            ));
        }


        if (!validateMobile($mobile)) {
            ms(array(
                'status' => 'error',
                'message' => "لطفا شماره همراه معتبری وارد نمایید",
            ));
        }


        if (strlen($mobile) !== 11) {
            ms(array(
                'status' => 'error',
                'message' => "شماره همراه باید شامل 11 عدد باشد نمونه: 09123456789",
            ));
        }


        if(isset($mobile) && !empty($mobile)){
            $user = $this->model->get("id", $this->tb_users, ['mobile' => $mobile]);

            if($user){
                ms(array(
                    'type' => 'send_otp',
                    'status' => 'error',
                    'message' => "شخصی با این شماره همراه در سایت وجود دارد لطفا شماره همراه دیگری انتخاب نمایید",
                ));
            }
        }


        if (empty($code)) {//اگر کد تایید خالی بود


            switch ($number_digits_otp){
                case "4":
                    $random_code = $six_digit_random_number = mt_rand(1000, 9999);//ساخت یک کد 4 رقمی رندوم
                    break;
                case "6":
                    $random_code = $six_digit_random_number = mt_rand(100000, 999999);//ساخت یک کد 6 رقمی رندوم
                    break;
            }

            $data['mobile'] = $mobile;
            $data['code'] = $random_code;
            //بررسی کن ببین با این شماره همراه کد گرفته یا نه
            $is_mobile = $this->model->get("*", "otp", ['mobile' => $mobile]);
            if($is_mobile){//اگر وجود داره آپدیت کن
                $status_create_otp = $this->db->update("otp", ['code' => $random_code],['mobile' => $mobile]);
            }else{
                $status_create_otp = $this->db->insert("otp", $data);
            }

            if ($status_create_otp) {// اگر کد و موبایل در دیتابیس ذخیره شد


                //کد تایید رو ارسال کن
                $result = send_sms_otp($random_code, $mobile);


                if ($result) {
                    ms(array(
                        'type' => 'send_otp',
                        'status' => 'success',
                        'message' => "کد تایید با موفقیت برای شما ارسال شد",
                    ));
                } else {
                    ms(array(
                        'type' => 'send_otp',
                        'status' => 'error',
                        'message' => "خطایی رخ داده است",
                    ));

                }

                return $result;


            }

        } else {//اگر کد تایید ارسال شده

            if (empty($code)) {
                ms(array(
                    'status' => 'error',
                    'message' => "لطفا کد تایید شماره همراه را وارد نمایید",
                ));
            }

            if (!is_numeric($code)) {
                ms(array(
                    'status' => 'error',
                    'message' => "لطفا برای کد تایید تنها از عدد استفاده نمایید",
                ));
            }

            // check mobile
            $checkOtpMobile = $this->model->get('id', "otp", ['code' => $code, 'mobile' => $mobile]);
            if (empty($checkOtpMobile)) {
                ms(array(
                    'type' => 'check_otp',
                    'status' => 'error',
                    'message' => "کد تایید وارد شده صحیح نیست",
                ));
            } else {


                //اضافه شدن شماره موبایل با morteza
                $uid = session('uid');
                $data = array(
                    "mobile" => $mobile,
                );
                $status = $this->db->update($this->tb_users, $data, "id = '" . $uid . "'");

                if($status){
                    $this->db->delete( "otp", $data);
                }

                ms(array(
                    'type' => 'check_otp',
                    'status' => 'success',
                    'message' => "شماره همراه شما تایید شد",
                    'redirect' => ""
                ));

            }

        }

    }


}