<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . './modules/auth/libraries/google/autoload.php';

class auth extends My_UserController
{
    public $tb_users;
    public $tb_user_logs;
    public $tb_user_block_ip;
    public $google_capcha;

    public function __construct()
    {
        parent::__construct();
        $this->load->model(get_class($this) . '_model', 'model');
        $this->tb_users = USERS;
        $this->tb_user_logs = USER_LOGS;
        $this->tb_user_block_ip = USER_BLOCK_IP;

        if (get_option("enable_goolge_recapcha", '') && get_option('google_capcha_site_key') != "" && get_option('google_capcha_secret_key') != "") {
            $this->recaptcha = new \ReCaptcha\ReCaptcha(get_option('google_capcha_secret_key'));
        }

        if (session("uid") && segment(2) != 'logout') {
            redirect(cn("statistics"));
        }
    }

    public function index()
    {
        redirect(cn("auth/login"));
    }


    public function login()
    {
        $this->lang->load('../../../../themes/' . get_theme() . '/language/english/' . get_theme());
        $data = array();
        $this->template->set_layout('blank_page');
        $this->template->build('../../../themes/' . get_theme() . '/views/sign_in', $data);
    }

    public function logout()
    {
        /*----------  Insert User logs  ----------*/
        $this->insert_user_activity_logs('logout');
        unset_session("uid");
        unset_session("auto_confirm");
        unset_session("user_current_info");
        $this->session->sess_destroy();
        if (get_option("is_maintenance_mode")) {
            delete_cookie("verify_maintenance_mode");
        }
        redirect(cn(''));
    }

    public function signup()
    {
        if (get_option('disable_signup_page')) {
            redirect(cn('auth/login'));
        }
        $this->lang->load('../../../../themes/' . get_theme() . '/language/english/' . get_theme());
        $data = array();
        $this->template->set_layout('blank_page');
        $this->template->build('../../../themes/' . get_theme() . '/views/sign_up', $data);
    }

    public function forgot_password()
    {
        $this->lang->load('../../../../themes/' . get_theme() . '/language/english/' . get_theme());
        $data = array();
        $this->template->set_layout('blank_page');
        $this->template->build('../../../themes/' . get_theme() . '/views/forgot_password', $data);
    }

    public function reset_password()
    {
        /*----------  check users exists  ----------*/
        $reset_key = segment(3);
        $user = $this->model->get("id, ids, email", $this->tb_users, "reset_key = '{$reset_key}'");
        if (!empty($user)) {
            // redirect to change password page
            $data = array(
                "reset_key" => $reset_key,
            );
            $this->lang->load('../../../../themes/' . get_theme() . '/language/english/' . get_theme());
            $this->template->set_layout('blank_page');
            $this->template->build('../../../themes/' . get_theme() . '/views/change_password', $data);
        } else {
            redirect(cn("auth/login"));
        }
    }

    public function ajax_sign_up($ids = "")
    {
        _is_ajax(get_class($this));
        $terms = post('terms');
        $first_name = post('first_name');
        $last_name = post('last_name');
        $email = post('email');
        $password = post('password');
        $re_password = post('re_password');
        $timezone = post('timezone');
        $enable_mobile_in_register = get_option('enable_mobile_in_register', "0");

        if (get_option('enable_sms_system', "0") == '1') {//اگر سیستم پیامک فعال بود
            $mobile = post('mobile');//for sms
            $code = post('code');//for sms

            //اگر ثبت نام با موبایل فعال باشه
            //for sms


            if ($enable_mobile_in_register === "1") {
                if (empty($mobile)) {
                    ms(array(
                        'status' => 'error',
                        'message' => "لطفا شماره همراه را وارد نمایید",
                    ));
                }

                if (empty($code)) {
                    ms(array(
                        'status' => 'error',
                        'message' => "لطفا کد تایید شماره همراه را وارد نمایید",
                    ));
                }

                if (!is_numeric($mobile)) {
                    ms(array(
                        'status' => 'error',
                        'message' => "لطفا شماره همراه معتبری وارد نمایید",
                    ));
                }

                if (!is_numeric($code)) {
                    ms(array(
                        'status' => 'error',
                        'message' => "لطفا کد تایید شماره همراه معتبری وارد نمایید",
                    ));
                }

                if (!validateMobile($mobile)) {
                    ms(array(
                        'status' => 'error',
                        'message' => "لطفا شماره همراه معتبری وارد نمایید",
                    ));
                }


                if (strlen($mobile) !== 11) {
                    ms(array(
                        'status' => 'error',
                        'message' => "شماره همراه باید شامل 11 عدد باشد نمونه: 09123456789",
                    ));
                }

                // check email
                $checkOtpMobile = $this->model->get('id', "otp", ['code' => $code, 'mobile' => $mobile]);
                if (empty($checkOtpMobile)) {
                    ms(array(
                        'type' => 'check_otp',
                        'status' => 'error',
                        'message' => "کد تایید وارد شده صحیح نیست",
                    ));
                }
            }

            if ($first_name == '' || $last_name == '' || $password == '') {//for sms
                ms(array(
                    'status' => 'error',
                    'message' => lang("please_fill_in_the_required_fields"),
                ));
            }

            //for sms
            if (!empty($mobile) || (!empty($email) && is_numeric($email))) {
                $user = $this->model->get("id", $this->tb_users, ['mobile' => $mobile]);

                if ($user) {
                    ms(array(
                        'status' => 'error',
                        'message' => "حساب کاربری با این شماره همراه در سایت وجود دارد لطفا شماره همراه دیگری انتخاب نمایید",
                    ));
                }
            }


            if (get_option('disable_email_in_register', 0) === "0") {//اگر ایمیل در ثبت نام فعال بود ایمیل رو بررسی کن
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    ms(array(
                        'status' => 'error',
                        'message' => lang("invalid_email_format"),
                    ));
                }
            }

            //for sms
            if (get_option('disable_email_in_register', 0) === "0") {//اگر ایمیل در ثبت نام فعال بود ایمیل رو بررسی کن
                if ($email == '') {
                    ms(array(
                        'status' => 'error',
                        'message' => lang("please_fill_in_the_required_fields"),
                    ));
                }
            }

        } else {
            if ($first_name == '' || $last_name == '' || $password == '' || $email == '') {
                ms(array(
                    'status' => 'error',
                    'message' => lang("please_fill_in_the_required_fields"),
                ));
            }
        }

        if (!preg_match('/^([a-zA-Z0-9 پچجحخهعغفقثصضشسیبلاتنمکگوئدذرزطظژؤإآأءًٌٍَُِّ])+$/u', $first_name)) {//change by morteza
            ms(array(
                'status' => 'error',
                'message' => lang("only_letters_and_white_space_allowed"),
            ));
        }

        if (!preg_match('/^([a-zA-Z0-9 پچجحخهعغفقثصضشسیبلاتنمکگوئدذرزطظژؤإآأءًٌٍَُِّ])+$/u', $last_name)) {//change by morteza
            ms(array(
                'status' => 'error',
                'message' => lang("only_letters_and_white_space_allowed"),
            ));
        }


        if ($password != '') {
            if (strlen($password) < 6) {
                ms(array(
                    'status' => 'error',
                    'message' => lang("Password_must_be_at_least_6_characters_long"),
                ));
            }

            if ($re_password != $password) {
                ms(array(
                    'status' => 'error',
                    'message' => lang("Password_must_be_at_least_6_characters_long"),
                ));
            }
        }

        if (!$terms) {
            ms(array(
                'status' => 'error',
                'message' => lang("oops_you_must_agree_with_the_terms_of_services_or_privacy_policy"),
            ));
        }

        if ($this->is_banned_ip_address()) {
            ms(array(
                "status" => "error",
                "message" => "Access from your IP address has been blocked for security reasons. Please contact the administrator!"
            ));
        }

        if (isset($_POST['g-recaptcha-response']) && get_option("enable_goolge_recapcha", '') && get_option('google_capcha_site_key') != "" && get_option('google_capcha_secret_key') != "") {
            $resp = $this->recaptcha->setExpectedHostname($_SERVER['SERVER_NAME'])
                ->verify($_POST['g-recaptcha-response'], $_SERVER['REMOTE_ADDR']);
            if (!$resp->isSuccess()) {
                ms(array(
                    'status' => 'error',
                    'message' => lang("please_verify_recaptcha"),
                ));
            }
        }

//        if (get_option('enable_sms_system', "0") == '1') {//اگر سیستم پیامک فعال بود
//            $mobile = post('mobile');//for sms
//            $code = post('code');//for sms
//
//            //اگر ثبت نام با موبایل فعال باشه
//            //for sms
//
//
//            if ($enable_mobile_in_register === "1") {
//                // check email
//                $checkOtpMobile = $this->model->get('id', "otp", ['code' => $code, 'mobile' => $mobile]);
//                if (empty($checkOtpMobile)) {
//                    ms(array(
//                        'type' => 'check_otp',
//                        'status' => 'error',
//                        'message' => "کد تایید وارد شده صحیح نیست",
//                    ));
//                }
//            }
//        }
        // Get Settings (Limit payments) for new user
        $limit_payments = $this->model->get_payments_list_for_new_user();
        $settings = [
            'limit_payments' => $limit_payments
        ];

        $data = array(
            "ids" => ids(),
            "first_name" => $first_name,
            "last_name" => $last_name,
            "password" => $this->model->app_password_hash($password),
            "timezone" => $timezone,
            "status" => get_option('is_verification_new_account', 0) ? 0 : 1,
            "api_key" => create_random_string_key(32),
            "settings" => json_encode($settings),
            'history_ip' => get_client_ip(),
            "reset_key" => create_random_string_key(32),
            "activation_key" => create_random_string_key(32),
            "changed" => NOW,
        );

        if (get_option("enable_signup_skype_field", '')) {
            $skype_id = post("skype_id");
            if ($skype_id == '') {
                ms(array(
                    'status' => 'error',
                    'message' => lang("please_fill_in_the_required_fields"),
                ));
            }
            $more_information = array(
                "skype_id" => $skype_id,
            );
            $data['more_information'] = json_encode($more_information);
        }

//        if($email != ''){
        // check email
        if (get_option('enable_sms_system', "0") == '1' && get_option('disable_email_in_register', 0) === "0") {//اگر ایمیل در ثبت نام فعال بود ایمیل رو بررسی کن
            $checkUserEmail = $this->model->get('email, ids', $this->tb_users, "email='{$email}'");
            if (!empty($checkUserEmail)) {
                ms(array(
                    'status' => 'error',
                    'message' => lang("An_account_for_the_specified_email_address_already_exists_Try_another_email_address"),
                ));
            }

//            $data['created'] = NOW;



        }

        if(!empty($email)){
            $data['email'] = $email;
        }

        $data['login_type'] = 'Sign_up_page';
        $data['created'] = NOW;


        if ($this->db->insert($this->tb_users, $data)) {
            $uid = $this->db->insert_id();


            if (get_option('enable_sms_system', "0") == '1') {
                //اضافه شدن شماره موبایل با morteza for sms
                $data = array(
                    "mobile" => $mobile,
                );
                $this->db->update($this->tb_users, $data, "id = '" . $uid . "'"); //for sms
                $this->db->delete("otp", ['mobile' => $mobile]);

                //اضافه شدن کاربر جدید به مخاطبین فراز
                add_to_phonebook($mobile);//for sms
            }


            if (get_option('is_verification_new_account', 0)) {
                $check_send_email_issue = $this->model->send_email(get_option('verification_email_subject', ''), get_option('verification_email_content', 0), $uid);
                if ($check_send_email_issue) {
                    ms(array(
                        "status" => "error",
                        "message" => $check_send_email_issue,
                    ));
                }

                ms(array(
                    "status" => "success",
                    "message" => lang('thank_you_for_signing_up_please_check_your_email_to_complete_the_account_verification_process')
                ));
            } else {
                set_session('uid', $uid);
                $data_session = array(
                    'role' => 'user',
                    'email' => isset($email) && !empty($email) ?$email:'',
                    'mobile' => isset($mobile) && !empty($mobile) ?$mobile:'',
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                    'timezone' => $timezone,
                );

                if (get_option('enable_sms_system', "0") == '1' && $enable_mobile_in_register == 0) {//اگر ورود با کد موبایل و کد تایید فعال نبود ایمیل رو هم اضافه کن for sms
                    $data_session['email'] = $email;
                }


                set_session('user_current_info', $data_session);

                /*----------  Insert User logs  ----------*/
                $this->insert_user_activity_logs('logout');

                /*----------  Check is send welcome email or not  ----------*/
                if (get_option("is_welcome_email", '')) {
                    $check_send_email_issue = $this->model->send_email(get_option('email_welcome_email_subject', ''), get_option('email_welcome_email_content', 0), $uid);
                    if ($check_send_email_issue) {
                        ms(array(
                            "status" => "error",
                            "message" => $check_send_email_issue,
                        ));
                    }
                }

                //ارسال پیام خوش آمدگویی به کاربر
                //for sms
                if (get_option('enable_sms_system', "0") == '1' && get_option("enable_sms_welcome_content", 0) == 1) {
                    send_sms_welcome_content([
                        'first_name'=>$first_name,
                        'last_name'=>$last_name,
                        'mobile'=>$mobile,
                    ]);
                }



                /*----------  Send email notificaltion for Admin  ----------*/
                if (get_option("is_new_user_email", '')) {
                    $subject = get_option('email_new_registration_subject', '');
                    $subject = str_replace("{{website_name}}", get_option("website_name", "SmartPanel"), $subject);

                    $email_content = get_option('email_new_registration_content', '');
                    $email_content = str_replace("{{user_firstname}}", $first_name, $email_content);
                    $email_content = str_replace("{{user_lastname}}", $last_name, $email_content);
                    $email_content = str_replace("{{website_name}}", get_option("website_name", "SmartPanel"), $email_content);
                    $email_content = str_replace("{{user_timezone}}", $timezone, $email_content);
                    $email_content = str_replace("{{user_email}}", $email, $email_content);

                    $admin_id = $this->model->get("id", $this->tb_users, "role = 'admin'", "id", "ASC")->id;
                    if ($admin_id == "") {
                        $admin_id = 1;
                    }

                    $check_send_email_issue = $this->model->send_email($subject, $email_content, $admin_id, false);
                    if ($check_send_email_issue) {
                        ms(array(
                            "status" => "error",
                            "message" => $check_send_email_issue,
                        ));
                    }
                }

                //ارسال پیام کاربر جدید به مدیر
                //for sms
                if (get_option('enable_sms_system', "0") == '1' && get_option("enable_sms_new_registration", 0) == 1) {
                    send_sms_new_registration([
                        'first_name'=>$first_name,
                        'last_name'=>$last_name,
                        'mobile'=>$mobile,
                    ]);
                }


            }

            //add for affiliate module
            if (isset($_COOKIE["ref_id"]) && !empty($_COOKIE["ref_id"])) {
                $ref_data['referral_user_id'] = $_COOKIE["ref_id"];
                $ref_data['referred_user_id'] = $uid;
                if ($this->db->insert('affiliate_users', $ref_data)) {
                    delete_cookie('ref_id');
                }
            }

            //add for affiliate module
            $affiliate_exist = get_field(PURCHASE, ['pid' => 27553], 'purchase_code');
            if ($affiliate_exist && isset($_COOKIE["ref_id"]) && !empty($_COOKIE["ref_id"])) {
                $ref_data['referral_user_id'] = $_COOKIE["ref_id"];
                $ref_data['referred_user_id'] = $uid;
                if ($this->db->insert('affiliate_users', $ref_data)) {
                    delete_cookie('ref_id');
                }
            }
            //end add for affiliate module

            ms(array(
                'status' => 'success',
                'message' => lang("welcome_you_have_signed_up_successfully"),
            ));
        } else {
            ms(array(
                "status" => "Failed",
                "message" => lang("There_was_an_error_processing_your_request_Please_try_again_later")
            ));
        }
//        }
    }

    public function activation($activation_key = "")
    {
        $user = $this->model->get("id, first_name, last_name, timezone, email, activation_key", $this->tb_users, "activation_key = '" . $activation_key . "'");
        if (!empty($user)) {
            $this->db->update($this->tb_users, ['status' => 1, 'activation_key' => 1], ['id' => $user->id]);
            /*----------  Check is send welcome email or not  ----------*/
            if (get_option("is_welcome_email", '')) {
                $check_send_email_issue = $this->model->send_email(get_option('email_welcome_email_subject', ''), get_option('email_welcome_email_content', 0), $user->id);
                if ($check_send_email_issue) {
                    ms(array(
                        "status" => "error",
                        "message" => $check_send_email_issue,
                    ));
                }
            }

            /*----------  Send email notificaltion for Admin  ----------*/
            if (get_option("is_new_user_email", '')) {
                $subject = get_option('email_new_registration_subject', '');
                $subject = str_replace("{{website_name}}", get_option("website_name", "SmartPanel"), $subject);

                $email_content = get_option('email_new_registration_content', '');
                $email_content = str_replace("{{user_firstname}}", $user->first_name, $email_content);
                $email_content = str_replace("{{user_lastname}}", $user->last_name, $email_content);
                $email_content = str_replace("{{website_name}}", get_option("website_name", "SmartPanel"), $email_content);
                $email_content = str_replace("{{user_timezone}}", $user->timezone, $email_content);
                $email_content = str_replace("{{user_email}}", $user->email, $email_content);

                $admin_id = $this->model->get("id", $this->tb_users, "role = 'admin'", "id", "ASC")->id;
                if ($admin_id == "") {
                    $admin_id = 1;
                }

                $check_send_email_issue = $this->model->send_email($subject, $email_content, $admin_id, false);
                if ($check_send_email_issue) {
                    ms(array(
                        "status" => "error",
                        "message" => $check_send_email_issue,
                    ));
                }
            }

            $this->lang->load('../../../../themes/' . get_theme() . '/language/english/' . get_theme());
            $data = array();
            $this->template->set_layout('blank_page');
            $this->template->build('../../../themes/' . get_theme() . '/views/activation_successfully', $data);
        } else {
            redirect(cn("auth/login"));
        }
    }

    public function ajax_sign_in()
    {

        //گرفتن تنظیمات نوع ورود به سایت
        //for sms
        $login_type = get_option('login_type', "login_by_email_password");
        $number_digits_otp = empty(get_option('number_digits_otp', "4")) ? 4 : get_option('number_digits_otp', "4");

        if (empty($login_type) || get_option('enable_sms_system', "0") == '0') {
            $login_type = "login_by_email_password";
        }

        $mobile = post("mobile");//morteza for sms
        $code = post("code");//morteza for sms


        $email = post("email");
        $password = md5(post("password"));
        $remember = post("remember");

        //for sms
        if ($login_type == "login_by_email_mobile_password" || $login_type == "login_by_email_password") {
            $text = "";
            if ($email == "") { //اگر ایمیل یا شماره همراه وارد نشده بود
                if ($login_type == "login_by_email_mobile_password") {
                    $text = "وارد کردن ایمیل یا شماره همراه ضروری است";
                } else if ($login_type == "login_by_email_password") {
                    $text = "وارد کردن ایمیل ضروری است";
                }
                ms(array(
                    "status" => "error",
                    "message" => $text
                ));
            }
        }

        //for sms
        if ($login_type == "login_by_mobile_password" || $login_type == "login_by_otpcode") {

            if (empty($mobile)) {
                ms(array(
                    'status' => 'error',
                    'message' => "لطفا شماره همراه را وارد نمایید",
                ));
            }


            if (!is_numeric($mobile)) {
                ms(array(
                    'status' => 'error',
                    'message' => "لطفا شماره همراه معتبری وارد نمایید",
                ));
            }

            if (!validateMobile($mobile)) {
                ms(array(
                    'status' => 'error',
                    'message' => "لطفا شماره همراه معتبری وارد نمایید",
                ));
            }
        }


        //for sms
        if ($login_type == "login_by_mobile_password" || $login_type == "login_by_email_mobile_password" || $login_type == "login_by_email_password") {
            if ($password == "") {
                ms(array(
                    "status" => "error",
                    "message" => lang("Password_is_required")
                ));
            }
        }


        if ($this->is_banned_ip_address()) {
            ms(array(
                "status" => "error",
                "message" => "Access from your IP address has been blocked for security reasons. Please contact the administrator!"
            ));
        }

        if (isset($_POST['g-recaptcha-response']) && get_option("enable_goolge_recapcha", '') && get_option('google_capcha_site_key') != "" && get_option('google_capcha_secret_key') != "") {
            $resp = $this->recaptcha->setExpectedHostname($_SERVER['SERVER_NAME'])
                ->verify($_POST['g-recaptcha-response'], $_SERVER['REMOTE_ADDR']);
            if (!$resp->isSuccess()) {
                ms(array(
                    'status' => 'error',
                    'message' => lang("please_verify_recaptcha"),
                ));
            }
        }

        //اگر ورود با شماره همراه یا ایمیل بود
        if ($login_type == "login_by_email_mobile_password") {
            if (is_numeric($email)) {//اگر فقط عدد بود پس موبایل هست
                $user = $this->model->get("id, status, ids, email, password, role, first_name, last_name, timezone", $this->tb_users, ['mobile' => $email]);
            } else {//در غیر این صورت ایمیل هست
                $user = $this->model->get("id, status, ids, email, password, role, first_name, last_name, timezone", $this->tb_users, ['email' => $email]);
            }
        }

        //اگر ورود با شماره همراه بود
        if ($login_type == "login_by_mobile_password" || $login_type == "login_by_otpcode") {
            $user = $this->model->get("id, status, ids, email, password, role, first_name, last_name, timezone", $this->tb_users, ['mobile' => $mobile]);
        }

        //اگر ورود با ایمیل فعال بود
        if ($login_type == "login_by_email_password") {
            $user = $this->model->get("id, status, ids, email, password, role, first_name, last_name, timezone", $this->tb_users, ['email' => $email]);
        }


//		$user = $this->model->get("id, status, ids, email, password, role, first_name, last_name, timezone", $this->tb_users, ['email' => $email]);

        $error = false;


        if (!$user) {//اگر یوزری وجود نداشت
            $error = true;
        } else {
            if ($login_type == "login_by_mobile_password" || $login_type == "login_by_email_mobile_password" || $login_type == "login_by_email_password") {//اگر پسورد برای ورود فعال باشد
                // check the first with old hash password method
                if ($user->password == md5(post("password"))) {
                    // update new password_hash
                    $this->db->update($this->tb_users, ['password' => $this->model->app_password_hash(post("password"))], ['id' => $user->id]);
                    $error = false;
                } else {
                    // check the last hash password
                    if ($this->model->app_password_verify(post("password"), $user->password)) {
                        $error = false;
                    } else {
                        $error = true;
                    }
                }
            }//end if
        }

        if (!$error) {
            if ($user->status != 1) {
                ms(array(
                    "status" => "error",
                    "message" => lang("your_account_has_not_been_activated")
                ));
            }

            //اگر ورود به صورت موبایل یا ایمیل به همراه رمز عبور باشه
            if ($login_type == "login_by_mobile_password" || $login_type == "login_by_email_mobile_password" || $login_type == "login_by_email_password") {
                set_session("uid", $user->id);
                $data_session = array(
                    'role' => $user->role,
                    'email' => isset($user->email) && !empty($user->email) ?$user->email:'',
                    'first_name' => $user->first_name,
                    'last_name' => $user->last_name,
                    'timezone' => $user->timezone,
                );

                if (!empty($user->mobile)) {
                    $data_session['mobile'] = isset($user->mobile) && !empty($user->mobile) ?$user->mobile:'';
                }


                set_session('user_current_info', $data_session);
                $this->model->history_ip($user->id);
                /*----------  Insert User logs  ----------*/
                $this->insert_user_activity_logs();

                if ($remember) {
                    if (!empty($mobile)) {
                        set_cookie("cookie_mobile", encrypt_encode($mobile), 1209600);//morteza
                    }

                    set_cookie("cookie_email", encrypt_encode($email), 1209600);
                    set_cookie("cookie_pass", encrypt_encode(post("password")), 1209600);
                } else {
                    delete_cookie("cookie_mobile");//morteza
                    delete_cookie("cookie_email");
                    delete_cookie("cookie_pass");
                }

                ms(array(
                    "status" => "success",
                    "message" => lang("Login_successfully")
                ));
            }

            // اگر موبایل و کد تایید بود
            if ($login_type == "login_by_otpcode") {
                //اگر کد وجود داشت و مطابق نبود خطا بده
                if (empty($code)) {//اگر کد تایید خالی بود


                    switch ($number_digits_otp) {
                        case "4":
                            $random_code = $six_digit_random_number = mt_rand(1000, 9999);//ساخت یک کد 4 رقمی رندوم
                            break;
                        case "6":
                            $random_code = $six_digit_random_number = mt_rand(100000, 999999);//ساخت یک کد 6 رقمی رندوم
                            break;
                    }


                    $data['mobile'] = $mobile;
                    $data['code'] = $random_code;

                    $is_mobile = $this->model->get("*", "otp", ['mobile' => $mobile]);
                    if ($is_mobile) {//اگر وجود داره آپدیت کن
                        $status_create_otp = $this->db->update("otp", ['code' => $random_code], ['mobile' => $mobile]);
                    } else {
                        $status_create_otp = $this->db->insert("otp", $data);
                    }

                    if ($status_create_otp) {// اگر کد و موبایل در دیتابیس ذخیره شد


                        //کد تایید رو ارسال کن
                        $result = send_sms_otp($random_code, $mobile);


                        if ($result) {
                            ms(array(
                                'type' => 'send_otp',
                                'status' => 'success',
                                'message' => "کد تایید با موفقیت برای شما ارسال شد",
                            ));
                        } else {
                            ms(array(
                                'type' => 'send_otp',
                                'status' => 'error',
                                'message' => "خطایی رخ داده است",
                            ));

                        }

                        return $result;

                    }

                } else {//اگر کد تایید ارسال شده
                    // check email
                    if (empty($code)) {
                        ms(array(
                            'status' => 'error',
                            'message' => "لطفا کد تایید شماره همراه را وارد نمایید",
                        ));
                    }

                    if (!is_numeric($code)) {
                        ms(array(
                            'status' => 'error',
                            'message' => "لطفا کد تایید شماره همراه معتبری وارد نمایید",
                        ));
                    }

                    $checkOtpMobile = $this->model->get('id', "otp", ['code' => $code, 'mobile' => $mobile]);
                    if (empty($checkOtpMobile)) {
                        ms(array(
                            'type' => 'check_otp',
                            'status' => 'error',
                            'message' => "کد تایید وارد شده صحیح نیست",
                        ));
                    }

                    set_session("uid", $user->id);
                    $data_session = array(
                        'role' => $user->role,
                        'email' => $user->email,
                        'first_name' => $user->first_name,
                        'last_name' => $user->last_name,
                        'timezone' => $user->timezone,
                    );

                    if (!empty($user->mobile)) {
                        $data_session['mobile'] = $user->mobile;
                    }


                    set_session('user_current_info', $data_session);
                    $this->model->history_ip($user->id);
                    /*----------  Insert User logs  ----------*/
                    $this->insert_user_activity_logs();

                    if ($remember) {
                        set_cookie("cookie_mobile", encrypt_encode($mobile), 1209600);//morteza
                        set_cookie("cookie_email", encrypt_encode(post("email")), 1209600);
//                        set_cookie("cookie_pass", encrypt_encode(post("password")), 1209600);
                    } else {
                        delete_cookie("cookie_mobile");//morteza
                        delete_cookie("cookie_email");
                        delete_cookie("cookie_pass");
                    }
                    $this->db->delete("otp", ['mobile' => $mobile]);
                    ms(array(
                        "status" => "success",
                        "message" => lang("Login_successfully")
                    ));

                }
            }//پایان اگر موبایل با کد تایید بود
        } else {
            ms(array(
                "status" => "error",
                "message" => lang("email_address_and_password_that_you_entered_doesnt_match_any_account_please_check_your_account_again")
            ));
        }


    }


    public function ajax_sign_in_old()
    {
        _is_ajax(get_class($this));
        $email = post("email");
        $password = md5(post("password"));
        $remember = post("remember");

        if ($email == "") {
            ms(array(
                "status" => "error",
                "message" => lang("email_is_required")
            ));
        }

        if ($password == "") {
            ms(array(
                "status" => "error",
                "message" => lang("Password_is_required")
            ));
        }

        if ($this->is_banned_ip_address()) {
            ms(array(
                "status" => "error",
                "message" => "Access from your IP address has been blocked for security reasons. Please contact the administrator!"
            ));
        }

        if (isset($_POST['g-recaptcha-response']) && get_option("enable_goolge_recapcha", '') && get_option('google_capcha_site_key') != "" && get_option('google_capcha_secret_key') != "") {
            $resp = $this->recaptcha->setExpectedHostname($_SERVER['SERVER_NAME'])
                ->verify($_POST['g-recaptcha-response'], $_SERVER['REMOTE_ADDR']);
            if (!$resp->isSuccess()) {
                ms(array(
                    'status' => 'error',
                    'message' => lang("please_verify_recaptcha"),
                ));
            }
        }

        $user = $this->model->get("id, status, ids, email, password, role, first_name, last_name, timezone", $this->tb_users, ['email' => $email]);

        $error = false;
        if (!$user) {
            $error = true;
        } else {
            // check the first with old hash password method
            if ($user->password == md5(post("password"))) {
                // update new password_hash
                $this->db->update($this->tb_users, ['password' => $this->model->app_password_hash(post("password"))], ['id' => $user->id]);
                $error = false;
            } else {
                // check the last hash password
                if ($this->model->app_password_verify(post("password"), $user->password)) {
                    $error = false;
                } else {
                    $error = true;
                }
            }
        }

        if (!$error) {
            if ($user->status != 1) {
                ms(array(
                    "status" => "error",
                    "message" => lang("your_account_has_not_been_activated")
                ));
            }
            set_session("uid", $user->id);
            $data_session = array(
                'role' => $user->role,
                'email' => $user->email,
                'first_name' => $user->first_name,
                'last_name' => $user->last_name,
                'timezone' => $user->timezone,
            );
            set_session('user_current_info', $data_session);
            $this->model->history_ip($user->id);
            /*----------  Insert User logs  ----------*/
            $this->insert_user_activity_logs();

            if ($remember) {
                set_cookie("cookie_email", encrypt_encode(post("email")), 1209600);
                set_cookie("cookie_pass", encrypt_encode(post("password")), 1209600);
            } else {
                delete_cookie("cookie_email");
                delete_cookie("cookie_pass");
            }

            // Update new Reset key
            $this->db->update($this->tb_users, ['reset_key' => ids()], ['id' => $user->id]);

            ms(array(
                "status" => "success",
                "message" => lang("Login_successfully")
            ));
        } else {
            ms(array(
                "status" => "error",
                "message" => lang("email_address_and_password_that_you_entered_doesnt_match_any_account_please_check_your_account_again")
            ));
        }
    }

    public
    function ajax_forgot_password()
    {
        //گرفتن تنظیمات اینکه به صورت عادی هست یا با موبایل و کد تایید هست
        $enable_mobile = get_option('enable_mobile_in_forget_password', 0);

        if ($enable_mobile === "0") {//اگر بازیابی رمز عبور به صرت عادی با ایمیل بود

            $email = post("email");

            if ($email === "") {
                ms(array(
                    "status" => "error",
                    "message" => lang("email_is_required")
                ));
            }

            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                ms(array(
                    "status" => "error",
                    "message" => lang("invalid_email_format")
                ));
            }

            if (isset($_POST['g-recaptcha-response']) && get_option("enable_goolge_recapcha", '') && get_option('google_capcha_site_key') != "" && get_option('google_capcha_secret_key') != "") {
                $resp = $this->recaptcha->setExpectedHostname($_SERVER['SERVER_NAME'])
                    ->verify($_POST['g-recaptcha-response'], $_SERVER['REMOTE_ADDR']);
                if (!$resp->isSuccess()) {
                    ms(array(
                        'status' => 'error',
                        'message' => lang("please_verify_recaptcha"),
                    ));
                }
            }

            $user = $this->model->get("*", USERS, "email = '{$email}'");
            if (!empty($user)) {
                $email_error = $this->model->send_email(get_option("email_password_recovery_subject", ""), get_option("email_password_recovery_content", ""), $user->id);

                if ($email_error) {
                    ms(array(
                        "status" => "error",
                        "message" => $email_error
                    ));
                }

                ms(array(
                    "status" => "success",
                    "message" => lang("we_have_send_you_a_link_to_reset_password_and_get_back_into_your_account_please_check_your_email"),
                ));
            } else {
                ms(array(
                    "status" => "error",
                    "message" => lang("the_account_does_not_exists")
                ));
            }
        } else { //اگر ورود با شماره همراه و کد تایید بود

            $mobile = post("mobile");
            $code = post("code");
            $password = post("password");
            $number_digits_otp = empty(get_option('number_digits_otp', "4")) ? 4 : get_option('number_digits_otp', "4");

            //همه خطاها رو بررسی کن

            if (empty($mobile)) {
                ms(array(
                    'status' => 'error',
                    'message' => "لطفا شماره همراه را وارد نمایید",
                ));
            }


            if (!is_numeric($mobile)) {
                ms(array(
                    'status' => 'error',
                    'message' => "لطفا شماره همراه معتبری وارد نمایید",
                ));
            }


            if (!validateMobile($mobile)) {
                ms(array(
                    'status' => 'error',
                    'message' => "لطفا شماره همراه معتبری وارد نمایید",
                ));
            }


            if (strlen($mobile) !== 11) {
                ms(array(
                    'status' => 'error',
                    'message' => "شماره همراه باید شامل 11 عدد باشد نمونه: 09123456789",
                ));
            }

            //اگر همچین کسی با این شماره همراه ثبت نام نکرده
            $user = $this->model->get("*", $this->tb_users, ['mobile' => $mobile]);
            if (!$user) {
                ms(array(
                    "status" => "error",
                    "message" => "حساب کاربری با این شماره همراه وجود ندارد"
                ));
            }


            if (empty($code)) {//اگر کد تایید خالی بود

                switch ($number_digits_otp) {
                    case "4":
                        $random_code = $six_digit_random_number = mt_rand(1000, 9999);//ساخت یک کد 4 رقمی رندوم
                        break;
                    case "6":
                        $random_code = $six_digit_random_number = mt_rand(100000, 999999);//ساخت یک کد 6 رقمی رندوم
                        break;
                }

                $data['mobile'] = $mobile;
                $data['code'] = $random_code;


                $is_mobile = $this->model->get("*", "otp", ['mobile' => $mobile]);
                if ($is_mobile) {//اگر وجود داره آپدیت کن
                    $status_create_otp = $this->db->update("otp", ['code' => $random_code], ['mobile' => $mobile]);
                } else {
                    $status_create_otp = $this->db->insert("otp", $data);
                }


                if ($status_create_otp) {// اگر کد و موبایل در دیتابیس ذخیره شد


                    //کد تایید رو ارسال کن
                    $result = send_sms_otp($random_code, $mobile);


                    if ($result) {
                        ms(array(
                            'type' => 'send_otp',
                            'status' => 'success',
                            'message' => "کد تایید با موفقیت برای شما ارسال شد",
                        ));
                    } else {
                        ms(array(
                            'type' => 'send_otp',
                            'status' => 'error',
                            'message' => "خطایی رخ داده است",
                        ));

                    }

                    return $result;

                }


            } else {

                if (empty($code)) {
                    ms(array(
                        'status' => 'error',
                        'message' => "لطفا کد تایید شماره همراه را وارد نمایید",
                    ));
                }


                if (!is_numeric($code)) {
                    ms(array(
                        'status' => 'error',
                        'message' => "لطفا کد تایید شماره همراه معتبری وارد نمایید",
                    ));
                }


                //اگر کد وارد شده صحیح نیست
                $checkOtpMobile = $this->model->get('id', "otp", ['code' => $code, 'mobile' => $mobile]);
                if (empty($checkOtpMobile)) {
                    ms(array(
                        'type' => 'check_otp',
                        'status' => 'error',
                        'message' => "کد تایید وارد شده صحیح نیست",
                    ));
                }

                //اگر قسمت رمز عبور خالی بود
                if ($password == "") {
                    ms(array(
                        "status" => "error",
                        "message" => "وارد کردن رمز عبور ضروری است"
                    ));
                }

                //اگر رمز عبور زیر 6 حرف بود
                if (strlen($password) < 6) {
                    ms(array(
                        'status' => 'error',
                        'message' => lang("Password_must_be_at_least_6_characters_long"),
                    ));
                }


                //در نهایت رمز عبور رو آپدیت می کنیم
                $data = array(
                    "password" => $this->model->app_password_hash($password),
                    "reset_key" => ids(),
                    "changed" => NOW,
                );

                $this->db->update($this->tb_users, $data, "id = '" . $user->id . "'");
                if ($this->db->affected_rows() > 0) {
                    $this->db->delete("otp", ['mobile' => $mobile]);
                    ms(array(
                        "status" => "success",
                        "message" => lang("your_password_has_been_successfully_changed"),
                    ));


                } else {
                    ms(array(
                        "status" => "Failed",
                        "message" => lang("There_was_an_error_processing_your_request_Please_try_again_later")
                    ));
                }


            }
        }

    }

    public function ajax_forgot_password_old()
    {
        _is_ajax(get_class($this));
        $email = post("email");

        if ($email == "") {
            ms(array(
                "status" => "error",
                "message" => lang("email_is_required")
            ));
        }

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            ms(array(
                "status" => "error",
                "message" => lang("invalid_email_format")
            ));
        }

        if (isset($_POST['g-recaptcha-response']) && get_option("enable_goolge_recapcha", '') && get_option('google_capcha_site_key') != "" && get_option('google_capcha_secret_key') != "") {
            $resp = $this->recaptcha->setExpectedHostname($_SERVER['SERVER_NAME'])
                ->verify($_POST['g-recaptcha-response'], $_SERVER['REMOTE_ADDR']);
            if (!$resp->isSuccess()) {
                ms(array(
                    'status' => 'error',
                    'message' => lang("please_verify_recaptcha"),
                ));
            }
        }

        $user = $this->model->get("*", USERS, "email = '{$email}'");
        if (!empty($user)) {
            $email_error = $this->model->send_email(get_option("email_password_recovery_subject", ""), get_option("email_password_recovery_content", ""), $user->id);

            if ($email_error) {
                ms(array(
                    "status" => "error",
                    "message" => $email_error
                ));
            }

            ms(array(
                "status" => "success",
                "message" => lang("we_have_send_you_a_link_to_reset_password_and_get_back_into_your_account_please_check_your_email"),
            ));
        } else {
            ms(array(
                "status" => "error",
                "message" => lang("the_account_does_not_exists")
            ));
        }
    }

    public function ajax_reset_password($reset_key = "")
    {
        _is_ajax(get_class($this));
        $user = $this->model->get("id, ids, email", $this->tb_users, "reset_key = '{$reset_key}'");
        $password = post('password');
        $re_password = post('re_password');

        if ($password == '' || $re_password == '') {
            ms(array(
                'status' => 'error',
                'message' => lang("please_fill_in_the_required_fields"),
            ));
        }

        if ($password != '') {
            if (strlen($password) < 6) {
                ms(array(
                    'status' => 'error',
                    'message' => lang("Password_must_be_at_least_6_characters_long"),
                ));
            }

            if ($re_password != $password) {
                ms(array(
                    'status' => 'error',
                    'message' => lang("Password_must_be_at_least_6_characters_long"),
                ));
            }
        }

        if (!empty($user)) {
            $data = array(
                "password" => $this->model->app_password_hash($password),
                "reset_key" => ids(),
                "changed" => NOW,
            );

            $this->db->update($this->tb_users, $data, "id = '" . $user->id . "'");
            if ($this->db->affected_rows() > 0) {
                ms(array(
                    "status" => "success",
                    "message" => lang("your_password_has_been_successfully_changed"),
                ));
            } else {
                ms(array(
                    "status" => "Failed",
                    "message" => lang("There_was_an_error_processing_your_request_Please_try_again_later")
                ));
            }
        } else {
            ms(array(
                "status" => "error",
                "message" => lang("There_was_an_error_processing_your_request_Please_try_again_later")
            ));
        }
    }

    private function insert_user_activity_logs($type = '')
    {
        if (!$this->db->table_exists($this->tb_user_logs)) {
            return false;
        }
        if (session('uid')) {
            $ip_address = get_client_ip();
            $data_user_logs = array(
                "ids" => ids(),
                "uid" => session('uid'),
                "ip" => $ip_address,
                "type" => ($type == 'logout') ? 0 : 1,
                "created" => NOW,
            );
            $location = get_location_info_by_ip($ip_address);
            if ($location->country != 'Unknown' && $location->country != '') {
                $data_user_logs['country'] = $location->country;
            } else {
                $data_user_logs['country'] = 'Unknown';
            }
            $this->db->insert($this->tb_user_logs, $data_user_logs);
        }
    }

    private function is_banned_ip_address()
    {
        if (!$this->db->table_exists($this->tb_user_block_ip)) {
            return false;
        }
        $ip_address = get_client_ip();
        $check_item = $this->model->get('ip', $this->tb_user_block_ip, ["ip" => $ip_address]);
        if (!empty($check_item)) {
            return true;
        }
        return false;
    }

    /*
* start by morteza
* استفاده برای ارسال کد تایید
*/

    public function ajax_send_otp()
    {
        $type = post('type');
        $code = post('code');
        $mobile = post('mobile');
        $number_digits_otp = empty(get_option('number_digits_otp', "4")) ? 4 : get_option('number_digits_otp', "4");


        if (empty($mobile)) {
            ms(array(
                'status' => 'error',
                'message' => "لطفا شماره همراه را وارد نمایید",
            ));
        }

        if (!is_numeric($mobile)) {
            ms(array(
                'status' => 'error',
                'message' => "لطفا شماره همراه معتبری وارد نمایید",
            ));
        }


        if (!validateMobile($mobile)) {
            ms(array(
                'status' => 'error',
                'message' => "لطفا شماره همراه معتبری وارد نمایید",
            ));
        }


        if (strlen($mobile) !== 11) {
            ms(array(
                'status' => 'error',
                'message' => "شماره همراه باید شامل 11 عدد باشد نمونه: 09123456789",
            ));
        }

        if (isset($mobile) && !empty($mobile)) {
            $user = $this->model->get("id", $this->tb_users, ['mobile' => $mobile]);

            if ($user) {
                ms(array(
                    'type' => 'send_otp',
                    'status' => 'error',
                    'message' => "حساب کاربری با این شماره همراه در سایت وجود دارد لطفا شماره همراه دیگری انتخاب نمایید",
                ));
            }
        }


        if (empty($code)) {//اگر کد تایید خالی بود


            switch ($number_digits_otp) {
                case "4":
                    $random_code = $six_digit_random_number = mt_rand(1000, 9999);//ساخت یک کد 4 رقمی رندوم
                    break;
                case "6":
                    $random_code = $six_digit_random_number = mt_rand(100000, 999999);//ساخت یک کد 6 رقمی رندوم
                    break;
            }

            $data['mobile'] = $mobile;
            $data['code'] = $random_code;


            //بررسی کن ببین با این شماره همراه کد گرفته یا نه
            $is_mobile = $this->model->get("*", "otp", ['mobile' => $mobile]);
            if ($is_mobile) {//اگر وجود داره آپدیت کن
                $status_create_otp = $this->db->update("otp", ['code' => $random_code], ['mobile' => $mobile]);
            } else {
                $status_create_otp = $this->db->insert("otp", $data);
            }

            if ($status_create_otp) {// اگر کد و موبایل در دیتابیس ذخیره شد


                //کد تایید رو ارسال کن
                $result = send_sms_otp($random_code, $mobile);


                if ($result) {
                    ms(array(
                        'type' => 'send_otp',
                        'status' => 'success',
                        'message' => "کد تایید با موفقیت برای شما ارسال شد",
                    ));
                } else {
                    ms(array(
                        'type' => 'send_otp',
                        'status' => 'error',
                        'message' => "خطایی رخ داده است",
                    ));

                }

                return $result;


            }

        } else {//اگر کد تایید ارسال شده

            if (empty($code)) {
                ms(array(
                    'status' => 'error',
                    'message' => "لطفا کد تایید شماره همراه را وارد نمایید",
                ));
            }

            if (!is_numeric($code)) {
                ms(array(
                    'status' => 'error',
                    'message' => "لطفا برای کد تایید تنها از عدد استفاده نمایید",
                ));
            }

            // check email
            $checkOtpMobile = $this->model->get('id', "otp", ['code' => $code, 'mobile' => $mobile]);

            if (empty($checkOtpMobile)) {
                ms(array(
                    'type' => 'check_otp',
                    'status' => 'error',
                    'message' => "کد تایید وارد شده صحیح نیست",
                ));
            } else {
                switch ($type) {
                    case "register":

                        ms(array(
                            'type' => 'check_otp',
                            'status' => 'success',
                            'message' => "شماره همراه شما تایید شد",
                            'redirect' => cn("auth/signup?step=2&code=" . $code . "&mobile=" . $mobile)
                        ));
                        break;
                    case "signin":
                        ms(array(
                            'type' => 'check_otp',
                            'status' => 'success',
                            'message' => "شماره همراه شما تایید شد",
                            'redirect' => ""
                        ));
                        break;
                }

            }

        }


    }

    /*
     * end by morteza
     */
}