<?php
  $class_element = app_config('template')['form']['class_element'];
  $config_status = app_config('config')['status'];
  $current_config_status = (in_array($controller_name, $config_status)) ? $config_status[$controller_name] : $config_status['default'];
  $form_status = array_intersect_key(app_config('template')['status'], $current_config_status); 
  $form_status = array_combine(array_keys($form_status), array_column($form_status, 'name')); 

  $elements = [
    [
      'label'      => form_label('نام'),
      'element'    => form_input(['name' => 'name', 'value' => @$item['name'], 'type' => 'text', 'class' => $class_element]),
      'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
      'label'      => form_label('لینک API'),
      'element'    => form_input(['name' => 'url', 'value' => @$item['url'], 'type' => 'text', 'class' => $class_element,'dir'=>'ltr']),
      'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
      'label'      => form_label('کلید API'),
      'element'    => form_input(['name' => 'key', 'value' => hide_api_key(@$item['key']), 'type' => 'text', 'class' => $class_element,'dir'=>'ltr']),
      'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
      'label'      => form_label('وضعیت'),
      'element'    => form_dropdown('status', $form_status, @$item['status'], ['class' => $class_element]),
      'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
      'label'      => form_label('توضیحات'),
      'element'    => form_textarea(['name' => 'description', 'value' => htmlspecialchars_decode(@$item['description'], ENT_QUOTES), 'rows' => '3', 'class' => $class_element]),
      'class_main' => "col-md-12",
    ],
  ];

  if (!empty($item['id'])) {
    $modal_title = 'ویرایش (' . $item['name'] . ')';
  } else {
    $modal_title = 'افزودن';
  }
  $form_url = admin_url($controller_name."/store/");
  $redirect_url = admin_url($controller_name);
  $form_attributes = array('class' => 'form actionForm', 'data-redirect' => $redirect_url, 'method' => "POST");
  $form_hidden = ['id' => @$item['id']];
?>
<div id="main-modal-content">
  <div class="modal-dialog modal-md" role="document">
    <div class="modal-content">
        <div class="modal-header bg-pantone">
          <h4 class="modal-title"><i class="fa fa-edit"></i><?php echo $modal_title; ?></h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="بستن"></button>
        </div>
        <?php echo form_open($form_url, $form_attributes, $form_hidden); ?>
        <div class="modal-body">
          <div class="row justify-content-md-center">
            <div class="col-md-12 col-sm-12 col-xs-12">
              <div class="form-group">
                <small class="text-danger"><?=lang("add_edit_provider_note_desc")?></small>
              </div>
            </div>
            <?php echo render_elements_form($elements); ?>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary btn-min-width mr-1 mb-1">ذخیره</button>
          <button type="button" class="btn btn-dark" data-dismiss="modal">بستن</button>
        </div>
        <?php echo form_close(); ?>
    </div>
  </div>
</div>
