<?php
  $form_url = admin_url($controller_name."/store/");
  $modal_title = 'ویرایش ' . ucfirst($item['type']);
  $form_attributes = array('class' => 'form actionForm', 'data-redirect' => admin_url($controller_name), 'method' => "POST");
  $form_hidden = [
    'id'    => @$item['id'],
    'type'  => @$item['type'],
    'payment_params[type]'  => @$item['type']
  ];
  $class_element = app_config('template')['form']['class_element'];
  $config_status = app_config('config')['status'];
  $payment_params = json_decode($item['params']);
  $payment_option = $payment_params->option;

  $current_config_status = (in_array($controller_name, $config_status)) ? $config_status[$controller_name] : $config_status['default'];
  $form_status = array_intersect_key(app_config('template')['status'], $current_config_status); 
  $form_status = array_combine(array_keys($form_status), array_column($form_status, 'name')); 
  $form_new_users = [
    0 => "مجاز نیست",
    1 => "مجاز",
  ];
  $form_environment = [
    'live'    => "زنده (محصول)",
    'sandbox' => "حالت تست",
  ];

    //for gift charge
/*
$general_elements = [
    [
        'label'      => form_label('نام روش'),
        'element'    => form_input(['name' => "payment_params[name]", 'value' => @$item['name'], 'type' => 'text', 'class' => $class_element]),
        'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
        'label'      => form_label('مرتب سازی'),
        'element'    => form_input(['name' => 'sort', 'value' => @$item['sort'], 'type' => 'number', 'class' => $class_element]),
        'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
        'label'      => form_label('تعداد در ماه'),
        'element'    => form_input(['name' => "payment_params[numberOfReq]", 'value' => @$item['numberOfReq'], 'type' => 'text', 'class' => $class_element]),
        'class_main' => "col-md-6 col-sm-12 col-xs-12",
    ],
    [
        'label'      => form_label('زمان به دقیقه'),
        'element'    => form_input(['name' => "payment_params[freefundTime]", 'value' => @$item['freefundTime'], 'type' => 'text', 'class' => $class_element]),
        'class_main' => "col-md-6 col-sm-12 col-xs-12",
    ],
    [
        'label'      => form_label('حداقل هدیه (تومان)'),
        'element'    => form_input(['name' => "payment_params[min]", 'value' => @$item['min'], 'type' => 'text', 'class' => $class_element]),
        'class_main' => "col-md-6 col-sm-12 col-xs-12",
    ],
    [
        'label'      => form_label('حداکثر هدیه (تومان)'),
        'element'    => form_input(['name' => "payment_params[max]", 'value' => @$item['max'], 'type' => 'text', 'class' => $class_element]),
        'class_main' => "col-md-6 col-sm-12 col-xs-12",
    ],

    [
        'label'      => form_label('کاربران جدید'),
        'element'    => form_dropdown('payment_params[new_users]', $form_new_users, @$item['new_users'], ['class' => $class_element]),
        'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
        'label'      => form_label('وضعیت'),
        'element'    => form_dropdown('payment_params[status]', $form_status, @$item['status'], ['class' => $class_element]),
        'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
        'label'      => form_label('کارمزد تراکنش (%)'),
        'element'    => form_input(['name' => 'payment_params[option][tnx_fee]', 'value' => @$payment_option->tnx_fee, 'type' => 'text', 'class' => $class_element]),
        'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ]
];
*/




  $general_elements = [
    [
      'label'      => form_label('نام روش'),
      'element'    => form_input(['name' => "payment_params[name]", 'value' => @$item['name'], 'type' => 'text', 'class' => $class_element]),
      'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
      'label'      => form_label('مرتب سازی'),
      'element'    => form_input(['name' => 'sort', 'value' => @$item['sort'], 'type' => 'number', 'class' => $class_element]),
      'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
      'label'      => form_label('حداقل پرداخت'),
      'element'    => form_input(['name' => "payment_params[min]", 'value' => @$item['min'], 'type' => 'text', 'class' => $class_element]),
      'class_main' => "col-md-6 col-sm-12 col-xs-12",
    ],
    [
      'label'      => form_label('حداکثر پرداخت'),
      'element'    => form_input(['name' => "payment_params[max]", 'value' => @$item['max'], 'type' => 'text', 'class' => $class_element]),
      'class_main' => "col-md-6 col-sm-12 col-xs-12",
    ],
    [
      'label'      => form_label('کاربران جدید'),
      'element'    => form_dropdown('payment_params[new_users]', $form_new_users, @$item['new_users'], ['class' => $class_element]),
      'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
      'label'      => form_label('وضعیت'),
      'element'    => form_dropdown('payment_params[status]', $form_status, @$item['status'], ['class' => $class_element]),
      'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
      'label'      => form_label('کارمزد تراکنش (%)'),
      'element'    => form_input(['name' => 'payment_params[option][tnx_fee]', 'value' => @$payment_option->tnx_fee, 'type' => 'text', 'class' => $class_element]),
      'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ]
  ];


//add by morteza for gift charge modules
if (@$item['type'] == 'giftcharge') {
    $general_elements[2]['label'] = form_label('حداقل هدیه (تومان)');
    $general_elements[3]['label'] = form_label('حداکثر هدیه (تومان)');
    $general_elements[6] = [
        'label'      => '',
        'element'    => '',
        'class_main' => '',
    ];
}


  if (@$item['type'] == 'paypal') {
    array_pop($general_elements);
  }
?>
<div id="main-modal-content" class="payment-method-update-form">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
        <div class="modal-header bg-pantone">
          <h4 class="modal-title"><i class="fa fa-edit"></i> <?php echo $modal_title; ?></h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="بستن"></button>
        </div>
        <?php echo form_open($form_url, $form_attributes, $form_hidden); ?>
        <div class="modal-body">
          <div class="row justify-content-md-center">
            <?php echo render_elements_form($general_elements); ?>
          </div>
          <fieldset class="form-fieldset row">
            <?php
              include 'integrations/'. $item['type'] . '.php';
            ?>
          </fieldset>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary btn-min-width mr-1 mb-1">ذخیره</button>
          <button type="button" class="btn btn-dark" data-dismiss="modal">بستن</button>
        </div>
        <?php echo form_close(); ?>
    </div>
  </div>
</div>

