<?php
$ids = (!empty($item['id'])) ? $item['id']: '';
$form_url = admin_url($controller_name."/store/");
if ($ids != "") $form_url .= $ids;
$form_attributes = array('class' => 'form actionForm', 'data-redirect' => admin_url($controller_name), 'method' => "POST");
$form_hidden = ['id' => @$item['id']];

$class_element        = app_config('template')['form']['class_element'];
$class_element_editor = app_config('template')['form']['class_element_editor'];
$config_status        = app_config('config')['status'];

$current_config_status = (in_array($controller_name, $config_status)) ? $config_status[$controller_name] : $config_status['default'];
$form_status = array_intersect_key(app_config('template')['status'], $current_config_status);
$form_status = array_combine(array_keys($form_status), array_column($form_status, 'name'));

$form_type = [
    'home_page' => 'صفحه اصلی',
    'order_page' => 'صفحه سفارش',
    'add_funds_page' => 'صفحه افزودن اعتبار'
];

$form_color= [
    'success' => 'سبز',
    'info' => 'آبی',
    'warning' => 'زرد',
    'danger' => 'قرمز',
    'primary' => 'آبی آسمانی',
    'secondary' => 'خاکستری',
    'blue-grey' => 'آبی خاکستری',
    'dark' => 'تاریک',
    'blue' => 'آبی پر رنگ',
    'amber' => 'کهربایی',
    'cyan' => 'فیروزه ای',
    'grey-blue' => 'خاکستری آبی',
    'pink' => 'صورتی',
    'purple' => 'بنفش',
    'red' => 'قرمز پر رنگ',
    'teal' => 'سبزآبی',
    'yellow' => 'زرد پر رنگ',
];


$elements = [
    [
        'label'      => form_label('نوع'),
        'element'    => form_dropdown('type', $form_type, @$item['type'], ['class' => $class_element]),
        'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
        'label'      => form_label('رنگ پس زمینه هشدار'),
        'element'    => form_dropdown('color', $form_color, @$item['color'], ['class' => $class_element]),
        'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
        'label'      => form_label('برچسب دکمه'),
        'element'    => form_input(['name' => 'btn_label', 'value' => @$item['btn_label'], 'type' => 'text', 'class' => $class_element]),
        'class_main' => "col-md-6",
    ],
    [
        'label'      => form_label('لینک دکمه'),
        'element'    => form_input(['name' => 'btn_link', 'value' => @$item['btn_link'], 'type' => 'text', 'class' => $class_element]),
        'class_main' => "col-md-6",
    ],
    [
        'label'      => form_label('وضعیت'),
        'element'    => form_dropdown('status', $form_status, @$item['status'], ['class' => $class_element]),
        'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ],
    [
        'label'      => form_label('متن هشدار'),
        'element'    => form_textarea(['name' => 'description', 'value' => @html_entity_decode($item['description'], ENT_QUOTES), 'class' => $class_element_editor]),
        'class_main' => "col-md-12 col-sm-12 col-xs-12",
    ]

];

?>
<div id="main-modal-content">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-pantone">
                <h4 class="modal-title"><i class="fa fa-edit"></i> ویرایش</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="بستن"></button>
            </div>
            <?php echo form_open($form_url, $form_attributes, $form_hidden); ?>
            <div class="modal-body">
                <div class="row justify-content-md-center">
                    <?php echo render_elements_form($elements); ?>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary btn-min-width mr-1 mb-1">ذخیره</button>
                <button type="button" class="btn btn-dark" data-dismiss="modal">بستن</button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        plugin_editor('.plugin_editor', {height: 300});
    });
</script>