<?php
defined('BASEPATH') or exit('No direct script access allowed');

class alerts_model extends MY_Model
{
    public $tb_users;
    public $tb_categories;
    public $tb_services;
    public $tb_orders;
    public $tb_alerts;

    public function __construct()
    {
        parent::__construct();
        //Config Module
        $this->tb_users = USERS;
        $this->tb_categories = CATEGORIES;
        $this->tb_services = SERVICES;
        $this->tb_orders = ORDER;
        $this->tb_alerts = 'general_alerts';
        $this->tb_main = 'general_alerts';
    }

    public function list_items($params = null, $option = null)
    {
        $result = null;

        if ($option['task'] == 'list-items') {
            $this->db->select('id, uid, type, color, description,status,btn_label,btn_link, created, changed');
            $this->db->from($this->tb_main);
            $this->db->order_by('id', 'ASC');
            if ($params['pagination']['limit'] != "" && $params['pagination']['start'] >= 0) {
                $this->db->limit($params['pagination']['limit'], $params['pagination']['start']);
            }

            $query = $this->db->get();
            $result = $query->result_array();
        }

        if ($option['task'] == 'list-items2') {
            $this->db->select('type, color, description,status,btn_label,btn_link');
            $this->db->from($this->tb_main);
            $this->db->order_by('id', 'ASC');
            $query = $this->db->get();
            $result = $query->result_array();
        }

        return $result;
    }

    public function count_items($params = null, $option = null)
    {
        $result = null;
        if ($option['task'] == 'count-items-group-by-status') {
            $this->db->select('count(id) as count');
            $this->db->from($this->tb_main);
            $this->db->order_by('id', 'DESC');
            $query = $this->db->get();
            $result = $query->result_array();
        }

        // Count items for pagination
        if ($option['task'] == 'count-items-for-pagination') {
            $this->db->select('id');
            $this->db->from($this->tb_main);
            $query = $this->db->get();
            $result = $query->num_rows();
        }
        return $result;
    }

    public function save_item($params = null, $option = null)
    {
        switch ($option['task']) {
            case 'add-item':
                $data = [
                    "type" => post("type"),
                    "color" => post("color"),
                    "description" => htmlspecialchars($this->input->post('description'), ENT_QUOTES),
                    "btn_label" => post("btn_label"),
                    "btn_link" => post("btn_link"),
                    "created" => NOW,
                    "changed" => NOW,
                ];
                $this->db->insert($this->tb_main, $data);
                return ["status" => "success", "message" => 'بروزرسانی با موفقیت انجام شد'];
                break;

            case 'edit-item':
                $data = [
                    "type" => post("type"),
                    "color" => post("color"),
                    "description" => htmlspecialchars($this->input->post('description'), ENT_QUOTES),
                    "btn_label" => post("btn_label"),
                    "btn_link" => post("btn_link"),
                    "changed" => NOW,
                ];

                $this->db->update($this->tb_main, $data, ["id" => post('id')]);
                return ["status" => "success", "message" => 'بروزرسانی با موفقیت انجام شد'];
                break;

            case 'change-status':
                $this->db->update($this->tb_main, ['status' => $params['status'], 'changed' => NOW], ["id" => $params['id']]);
                return ["status" => "success", "message" => 'بروزرسانی با موفقیت انجام شد'];
                break;


            case 'bulk-action':
                if (in_array($params['type'], ['delete', 'deactive', 'active']) && empty($params['ids'])) {
                    return ["status" => "error", "message" => 'لطفا حداقل یک مورد را انتخاب کنید'];
                }
                $arr_ids = convert_str_number_list_to_array($params['ids']);
                switch ($params['type']) {
                    case 'delete':
                        $this->db->where_in('id', $arr_ids);
                        $this->db->delete($this->tb_main);
                        return ["status" => "success", "message" => 'بروزرسانی با موفقیت انجام شد'];
                        break;
                    case 'deactive':
                        $this->db->where_in('id', $arr_ids);
                        $this->db->update($this->tb_main, ['status' => 0]);
                        return ["status" => "success", "message" => 'بروزرسانی با موفقیت انجام شد'];
                        break;
                    case 'active':
                        $this->db->where_in('id', $arr_ids);
                        $this->db->update($this->tb_main, ['status' => 1]);
                        return ["status" => "success", "message" => 'بروزرسانی با موفقیت انجام شد'];
                        break;
                }
                break;
        }
    }

    public function get_item($params = null, $option = null)
    {
        $result = null;
        if($option['task'] == 'get-item'){
            $result = $this->get("id, type, color,btn_label,btn_link, description, status", $this->tb_main, ['id' => $params['id']], '', '', true);
        }
        return $result;
    }

    public function delete_item($params = null, $option = null)
    {
        $result = [];
        if($option['task'] == 'delete-item'){
            $item = $this->get("id, ids", $this->tb_main, ['id' => $params['id']]);
            if ($item) {
                $this->db->delete($this->tb_main, ["id" => $params['id']]);
                $result = [
                    'status' => 'success',
                    'message' => 'با موفقیت حذف شد',
                    "ids"     => $item->ids,
                ];
            }else{
                $result = [
                    'status' => 'error',
                    'message' => 'خطایی در پردازش درخواست شما وجود دارد. لطفاً بعداً دوباره امتحان کنید',
                ];
            }
        }
        return $result;
    }
}
