<?php
defined('BASEPATH') or exit('No direct script access allowed');

class alerts extends WP_BAZAR_SMARTPANEL_AdminController
{
    public $tb_users;
    public $tb_categories;
    public $tb_services;
    public $tb_orders;
    public $tb_alerts;
    public $api_key;
    public $uid;
    public $columns;

    public function __construct()
    {
        parent::__construct();
        $this->load->model(get_class($this).'_model', 'main_model');


        $this->controller_name   = strtolower(get_class($this));
        $this->controller_title  = ucfirst(str_replace('_', ' ', get_class($this)));
        $this->path_views        = "alerts";
        $this->params            = [];

        $this->columns     =  array(
            "faq"              => ['name' => 'توضیحات',      'class' => 'text-center'],
            "sort"             => ['name' => 'نوع',      'class' => 'text-center'],
            "changed"          => ['name' => 'تغییر کرد',  'class' => 'text-center'],
            "status"           => ['name' => 'وضعیت',   'class' => 'text-center'],
        );


    }


    public function store($id = null){
        if (!$this->input->is_ajax_request()) redirect(admin_url($this->controller_name));
        $this->form_validation->set_rules('type', 'type', 'trim|required|xss_clean');
        $this->form_validation->set_rules('color', 'color', 'trim|required|xss_clean');
        $this->form_validation->set_rules('btn_label', 'btn_label', 'trim|xss_clean');
        $this->form_validation->set_rules('btn_link', 'btn_link', 'trim|xss_clean');
        $this->form_validation->set_rules('status', 'status', 'trim|required|in_list[0,1]|xss_clean');
        $this->form_validation->set_rules('description', 'description', 'trim|required|xss_clean');

        if (!$this->form_validation->run()) _validation('error', validation_errors());

        $task = 'add-item';
        if($id !== null){
            $task   = 'edit-item';
        }
        $response = $this->main_model->save_item( $this->params, ['task' => $task]);
        ms($response);
    }

}

