<?php


class zarinpal extends MX_Controller
{
    public $tb_users;
    public $tb_transaction_logs;
    public $tb_payments;
    public $tb_payments_bonuses;
    public $payment_type;
    public $payment_fee;
    public $payment_lib;
    public $currency_code;
    public $mode;
    public $use_zarin_gate;
    public $zarinGate_gateway;
    public $MerchantID;
    public $payment_id;

    public function __construct($payment = "")
    {
        parent::__construct();
        $this->load->model('add_funds_model', 'model');

        $this->tb_users = USERS;
        $this->tb_transaction_logs = TRANSACTION_LOGS;
        $this->tb_payments = PAYMENTS_METHOD;
        $this->tb_payments_bonuses = PAYMENTS_BONUSES;
        $this->payment_type = "zarinpal";
        $this->currency_code = get_option("currency_code", "IRT");
        if ($this->currency_code == "") {
            $this->currency_code = 'IRT';
        }

        if (!$payment) {
            $payment = $this->model->get('id, type, name, params', $this->tb_payments, ['type' => $this->payment_type]);
        }

        $this->payment_id = $payment->id;
        $params = $payment->params;
        $option = get_value($params, 'option');
        $this->mode = get_value($option, 'environment');
        $this->payment_fee = get_value($option, 'tnx_fee');
        // options

        $this->use_zarin_gate = get_value($option, 'use_zarin_gate');
        $this->zarinGate_gateway = get_value($option, 'zarinGate_gateway');
        $this->MerchantID = get_value($option, 'MerchantID');

    }

    public function index()
    {
        redirect(cn("add_funds"));
    }

    /**
     *
     * Create payment
     *
     */
    public function create_payment($data_payment = "")
    {
        _is_ajax($data_payment['module']);
        $amount = $data_payment['amount'];


        if (!$amount) {
            _validation('error', lang('There_was_an_error_processing_your_request_Please_try_again_later'));
        }

        if (!$this->MerchantID) {
            _validation('error', lang('this_payment_is_not_active_please_choose_another_payment_or_contact_us_for_more_detail'));
        }

        $users = session('user_current_info');



        if ($this->mode == "sandbox") {//اگر حالت تست هست
            $client = new SoapClient('https://sandbox.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);
        } else {
            $client = new SoapClient('https://www.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8',"stream_context" => stream_context_create(
                array(
                    'ssl' => array(
                        'verify_peer'       => false,
                        'verify_peer_name'  => false,
                    )
                )
            )]);
        }


        //محاسبه کارمزد تراکنش
        if ($this->payment_fee > 0) {
            $payment_fee = $amount * ($this->payment_fee / 100);
        } else {
            $payment_fee = 0;
        }


        $result = $client->PaymentRequest(
            [
                'MerchantID' => $this->MerchantID,
                'Amount' => (int)$amount ,
                'Description' => 'شارژ اعتبار در' . get_option('website_name') . '. (' . isset($users['email']) && !empty($users['email']) ?$users['email']:"" . ')',
                'Email' => isset($users['email']) && !empty($users['email'])?$users['email']:"",
                'Mobile' => isset($users['mobile']) && !empty($users['mobile']) ?$users['mobile']:"",
                'CallbackURL' => cn("add_funds/zarinpal/complete"),
            ]
        );

        //Redirect to URL You can do it also by creating a form
        if ($result->Status == 100) {

            $data_tnx_log = array(
                "ids" => ids(),
                "uid" => session("uid"),
                "type" => $this->payment_type,
                "transaction_id" => $result->Authority,
                "amount" => (int)$amount,
                'txn_fee' => (int)$payment_fee,
                "status" => 0,
                "created" => NOW,
            );

            $transaction_log_id = $this->db->insert($this->tb_transaction_logs, $data_tnx_log);
            $url = $this->get_gateway($this->use_zarin_gate, $this->zarinGate_gateway, $result->Authority);

            if ($this->input->is_ajax_request()) {
                ms(['status' => 'success', 'redirect_url' => $url,'message' => 'شما به زودی به درگاه هدایت خواهید شد']);
            }

        } else {
            $error_message = $this->error($result->Status);
            _validation('error', $error_message);
        }

    }


    /**
     *
     * Call Execute payment after creating payment
     *
     */
    public function complete()
    {

        if (!isset($_GET['Authority'])) {
            redirect(cn("add_funds/unsuccess"));
        }

        $transaction = $this->model->get('*', $this->tb_transaction_logs, ['transaction_id' => $_GET['Authority'], 'status' => 0, 'uid' => session('uid'), 'type' => $this->payment_type]);

        if (!$transaction) {
            redirect(cn("add_funds"));
        }


        if ($_GET['Status'] == 'OK' && $transaction) {

            if ($this->mode == "sandbox") {//اگر حالت تست هست
                $client = new SoapClient('https://sandbox.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);
            } else {
                $client = new SoapClient('https://www.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8',"stream_context" => stream_context_create(
                    array(
                        'ssl' => array(
                            'verify_peer'       => false,
                            'verify_peer_name'  => false,
                        )
                    )
                )]);
            }


            $amount = $transaction->amount ;

            $result = $client->PaymentVerification(
                [
                    'MerchantID' => $this->MerchantID,
                    'Authority' => $_GET['Authority'],
                    'Amount' =>$amount,
                ]
            );

            if ($result->Status == 100) {

                $data_tnx_log = array(
                    "transaction_id" => $result->RefID,
                    'txn_fee'        => ($this->payment_fee > 0) ? $this->payment_fee : 0,
                    "status" => 1,
                );

                $this->db->update($this->tb_transaction_logs, $data_tnx_log, ['id' => $transaction->id]);

                // Update Balance
                $this->model->add_funds_bonus_email($transaction, $this->payment_id);

                set_session("transaction_id", $transaction->id);
//                $this->load->view("redirect", ['redirect_url' => cn("add_funds/success")]);
                redirect(cn("add_funds/success"));

            } else {
//                _validation('error', $result->Status);
                //حالت دیباگ اینجا فعال بشه
                if ($this->mode == "debug") {
                    echo $this->error($result->Status);
                    echo '<br>';
                    echo print_r($result);
                    die();
                }

                redirect(cn("add_funds/unsuccess"));
            }

        } else {
            //حالت دیباگ اینجا فعال بشه
            redirect(cn("add_funds/unsuccess"));
        }
    }

    public function get_gateway($use_zarin_gate, $select_gateway, $Authority)
    {
        if ($this->mode == "sandbox") {//اگر حالت تست هست
            $client = "https://sandbox.zarinpal.com/pg/StartPay/";
        } else {
            $client = "https://www.zarinpal.com/pg/StartPay/";
        }

        $url = $client . $Authority;
        if ($use_zarin_gate) {
            switch ($select_gateway) {
                case "RND":
                    $url = $client . $Authority . '/ZarinGat';
                    break;
                case "ASAN":
                    $url = $client . $Authority . '/Asan';
                    break;
                case "SEP":
                    $url = $client . $Authority . '/Sep';
                    break;
                case "SAD":
                    $url = $client . $Authority . '/Sad';
                    break;
                case "PEC":
                    $url = $client . $Authority . '/Pec';
                    break;
                case "FAN":
                    $url = $client . $Authority . '/Fan';
                    break;
                default:
                    $url = $client . $Authority . '/ZarinGat';
                    break;
            }
        }

        return $url;
    }

    public function error($error_id)
    {
        switch ($error_id) {
            case '-1':
                return 'اطلاعات ارسال شده ناقص است';
                break;
            case '-2':
                return 'IP یا مرچنت کد پذیرنده صحیح نیست';
                break;
            case '-3':
                return 'با توجه به محدودیت های شاپرک امکان پرداخت با رقم درخواست شده میسر نمی باشد';
                break;
            case '-4':
                return 'سطح تایید پذیرنده پایین تر از سطح نقره ای است';
                break;
            case '-11':
                return 'درخواست مورد نظر یافت نشد';
                break;
            case '-12':
                return 'امکان ویرایش درخواست میسر نمی باشد';
                break;
            case '-21':
                return 'هیچ نوع عملیان مالی برای این تراکنش یافت نشد';
                break;
            case '-22':
                return 'تراکنش ناموفق می باشد';
                break;
            case '-33':
                return 'رقم تراکنش با رقم پرداخت شده مطابقت ندارد';
                break;
            case '-34':
                return 'سطح تقسیم تراکنش از لحاظ تعداد یا رقم عبور نموده است';
                break;
            case '-40':
                return 'اجازه دسترسی به متد مربوطه وجود ندارد';
                break;
            case '-41':
                return 'اطلاعات ارسال شده مربوط به AdditionalData غیر معتبر می باشد';
                break;
            case '-42':
                return 'مدت زمان معتبر طول عمر شناسه پرداخت باید بین 30 دقیقه تا 45 روز باشد';
                break;
            case '-54':
                return 'درخواست مورد نظر آرشیو شده است';
                break;
            case '100':
                return 'عملیات با موفقیت انجام گردیده است';
                break;
            case '101':
                return 'عملیات پرداخت موفق بوده و قبلا PaymentVerification تراکنش انجام شده است';
                break;
        }
    }
}